/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.OutputType;
import java.io.OutputStream;

public class CommandResult {
    private String _outputString;
    private OutputStream _outputStream;
    private String _errorString;
    private OutputStream _errorStream;
    private InputType _inputType;
    private OutputType _outputType;
    private int _returnValue;
    private boolean _executedSuccessfully;
    private CommandContext _context;
    private CommandElement _command;

    public CommandResult(CommandElement command, CommandContext context) {
        this._command = command;
        this._context = context;
        this._outputType = context != null ? context.getOutputType() : OutputType.UNDEFINED;
    }

    public boolean executedSuccessfully() {
        return this._executedSuccessfully;
    }

    public CommandElement getCommand() {
        return this._command;
    }

    public CommandContext getContext() {
        return this._context;
    }

    public OutputStream getErrorStream() {
        return this._errorStream;
    }

    public String getErrorString() {
        return this._errorString;
    }

    public InputType getInputType() {
        return this._inputType;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public String getOutputString() {
        String result = this._outputString;
        if (result == null && this._outputStream != null) {
            result = this._outputStream.toString();
        }
        return result;
    }

    public OutputType getOutputType() {
        return this._outputType != null ? this._outputType : OutputType.UNDEFINED;
    }

    public int getReturnValue() {
        return this._returnValue;
    }

    void setExecutedSuccessfully(boolean value) {
        this._executedSuccessfully = value;
    }

    void setInputType(InputType inputType) {
        this._inputType = inputType;
    }

    void setOutputStream(OutputStream output) {
        this._outputStream = output;
    }

    void setOutputString(String output) {
        this._outputString = output;
    }

    void setErrorString(String err) {
        this._errorString = err;
    }

    void setReturnValue(int value) {
        this._returnValue = value;
    }
}

